# -*- coding: utf-8 -*-
"""
/***************************************************************************
 GeodbIODialog
                                 A QGIS plugin
 Connects to spatial data from geodb.io via api
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-02-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by geodb.io
        email                : admin@geodb.io
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'geodb_dialog_base.ui'))


class GeodbIODialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, plugin=None, parent=None):
        """Constructor."""
        super(GeodbIODialog, self).__init__(parent)
        self.plugin = plugin
        self.setupUi(self)


        # Connect the buttons to the appropriate functions
        self.login_submit.clicked.connect(self.handle_login)
        self.logout_submit.clicked.connect(self.plugin.logout)
        self.set_company.clicked.connect(self.plugin.set_company)
        self.set_project.clicked.connect(self.plugin.set_project)
        self.gpkg_browse.clicked.connect(self.plugin.gpkg_browse)
        self.gpkg_checkfile.clicked.connect(self.plugin.gpkg_checkfile)
        self.model_pull.clicked.connect(self.plugin.data_pull) 
        self.pull_modelBox.currentTextChanged.connect(self.plugin.toggle_assay_merge_options)
        self.push_modelBox.currentTextChanged.connect(self.plugin.toggle_push_options)
        self.model_push_getChanges.clicked.connect(self.plugin.get_push_changes)
        self.model_push_noDelete.clicked.connect(lambda: self.plugin.data_push(do_delete=False))
        self.model_push_doDelete.clicked.connect(lambda: self.plugin.data_push(do_delete=True))


    def handle_login(self):
        """
        This method will be called when the login_submit button is clicked
        This one is required here because we are getting the input
        """
        email = self.email_input.text()
        password = self.password_input.text()
        self.plugin.login(email, password)

    def show_progress_bar(self):
        """Show the progress bar"""
        self.progress_bar.setVisible(True)

    def hide_progress_bar(self):
        """Hide the progress bar"""
        self.progress_bar.setVisible(False)

    def update_progress(self, value):
        """Update the progress bar value"""
        self.progress_bar.setValue(value)
